

function [swa_norm] = slowwaveactivity(signal,N)

% FFT Windows
win = 1024;
step = 256; 
nS = length(signal);
T1 = 1:step:(nS-win+1);
T2 = win:step:nS;

% Hann window
Hann = 0.5*(1-cos(2*pi*(0:win-1)/(win-1)));

% FFT each window
nWin = length(T1);
swa = zeros(1,nWin);
for w=1:nWin
    t1 = T1(w);
    t2 = T2(w);
    segment = signal(t1:t2);
    ffteeg = fft(segment.*Hann);
    ffteeg = abs(ffteeg/win);
    ffteeg = ffteeg(1:win/2+1);
    ffteeg(2:end-1) = 2*ffteeg(2:end-1);
    
    swa(w) = mean(ffteeg(3:17).^2);
end

% Smooth into epochs
smooth = 2;
nEps = length(signal)/1024;
swa_smooth = zeros(1,nEps);
for ep=1:nEps
    idx = (ep-1)*4 +1;
	t1 = max([1, idx-smooth]);
    t2 = min([idx+smooth,nWin]);
    swa_smooth(ep) = median(swa(t1:t2));
end

% Norm
baselineNREM = N;
baselineNREM(21151:end) = 0;
baselineNREM = logical(baselineNREM);
mBN_SWA = mean(swa_smooth(baselineNREM));
swa_norm = swa_smooth*(100/mBN_SWA);


end




